// IMPORTANT: LCDWIKI_KBV LIBRARY MUST BE SPECIFICALLY
// CONFIGURED FOR EITHER THE TFT SHIELD OR THE BREAKOUT BOARD.

//This program is a demo of displaying string
//Set the pins to the correct ones for your development shield or breakout board.
//the 16bit mode only use in Mega.you must modify the mode in the file of lcd_mode.h
//when using the BREAKOUT BOARD only and using these 16 data lines to the LCD,
//pin usage as follow:
//             CS  CD  WR  RD  RST  D0  D1  D2  D3  D4  D5  D6  D7  D8  D9  D10  D11  D12  D13  D14  D15 
//Arduino Mega 40  38  39  /   41   37  36  35  34  33  32  31  30  22  23  24   25   26   27   28   29

//Remember to set the pins to suit your display module!

/**********************************************************************************
* @attention
*
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
* TIME. AS A RESULT, QD electronic SHALL NOT BE HELD LIABLE FOR ANY
* DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
* FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
* CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**********************************************************************************/

#include <LCDWIKI_GUI.h> //Core graphics library
#include <LCDWIKI_KBV.h> //Hardware-specific library

//the definiens of 16bit mode as follow:
//if the IC model is known or the modules is unreadable,you can use this constructed function
LCDWIKI_KBV mylcd(ILI9486,40,38,39,-1,41); //model,cs,cd,wr,rd,reset

//define some colour values
#define WHITE   0x0000
#define YELLOW    0x001F
#define CYAN     0xF800
#define PURPLE   0x07E0
#define RED    0x07FF
#define MAGENTA 0xF81F
#define BLUE  0xFFE0
#define BLACK   0xFFFF
#define GREEN   0xA254
String inputString = "";
boolean stringComplete = false;
void setup() 
{
  Serial.begin(9600);   // 初始化用于调试的串口
  Serial1.begin(9600);  // 初始化用于接收数据的串口（Serial1）
  Serial.print("Mega ready");
  mylcd.Init_LCD();
  mylcd.Fill_Screen(BLACK); 
  mylcd.Set_Rotation(3); 
  mylcd.Set_Text_Mode(0);
  mylcd.Set_Text_Back_colour(BLACK);

  mylcd.Set_Text_colour(WHITE);
  mylcd.Set_Text_Size(5);
  mylcd.Print_String("UESTC-China", 90, 60);

  mylcd.Set_Text_colour(YELLOW);
  mylcd.Set_Text_Size(8);
  mylcd.Print_String("REPEAT", 100, 150);
  delay(2000);

  mylcd.Fill_Screen(BLACK); 
  mylcd.Set_Rotation(3); 
  mylcd.Set_Text_Mode(0);
  mylcd.Set_Text_Back_colour(BLACK);

  mylcd.Set_Text_colour(PURPLE);
  mylcd.Set_Text_Size(3);
  mylcd.Print_String("F1(405-425nm):", 40, 30);

  mylcd.Set_Text_colour(BLUE);
  mylcd.Set_Text_Size(3);  
  mylcd.Print_String("F3(470-490nm):", 40, 80);

  mylcd.Set_Text_colour(CYAN);
  mylcd.Set_Text_Size(3);
  mylcd.Print_String("F4(505-525mm):", 40, 130);

  mylcd.Set_Text_colour(GREEN);
  mylcd.Set_Text_Size(3);
  mylcd.Print_String("F6(580-600mm):", 40, 180);

  mylcd.Set_Text_colour(YELLOW);
  mylcd.Set_Text_Size(3);
  mylcd.Print_String("F7(620-640mm):", 40, 230);

  mylcd.Set_Text_colour(RED);
  mylcd.Set_Text_Size(3);  
  mylcd.Print_String("F8(670-690mm):", 40, 280);

  //mylcd.Set_Text_colour(BLUE);
  //mylcd.Set_Text_Size(3);
  //mylcd.Print_String("Hello World!", 0, 104);
  //mylcd.Print_Number_Float(01234.56789, 2, 0, 128, '.', 0, ' ');  
  //mylcd.Print_Number_Int(0xDEADBEF, 0, 152, 0, ' ',16);
  // mylcd.Print_String("DEADBEEF", 0, 152);
}
void loop() 
{
  int buffer;
  while (Serial1.available()) {
    buffer = Serial1.read();

      mylcd.Set_Text_colour(WHITE);
      mylcd.Set_Text_Size(3);
      mylcd.Print_Number_Int(buffer, 300, 30+0*50, 0, ' ',10);
      delay(2500);

      mylcd.Set_Text_colour(WHITE);
      mylcd.Set_Text_Size(3);
      mylcd.Print_Number_Int(buffer, 300, 30+1*50, 0, ' ',10);
      delay(2500);

      mylcd.Set_Text_colour(WHITE);
      mylcd.Set_Text_Size(3);
      mylcd.Print_Number_Int(buffer, 300, 30+2*50, 0, ' ',10);
      delay(2500);

      mylcd.Set_Text_colour(WHITE);
      mylcd.Set_Text_Size(3);
      mylcd.Print_Number_Int(buffer, 300, 30+3*50, 0, ' ',10);
      delay(2500);

      mylcd.Set_Text_colour(WHITE);
      mylcd.Set_Text_Size(3);
      mylcd.Print_Number_Int(buffer, 300, 30+4*50, 0, ' ',10);
      delay(2500);

      mylcd.Set_Text_colour(WHITE);
      mylcd.Set_Text_Size(3);
      mylcd.Print_Number_Int(buffer, 300, 30+5*50, 0, ' ',10);
      delay(2500);  

  }
}